﻿using MvcSample.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace MvcSample.Services
{
    public interface ILinkRepository
    {
        IQueryable<Link> GetLinks();
    }

    public class InMemoryLinkRepository: ILinkRepository
    {
        private readonly List<Link> _list;
        public InMemoryLinkRepository()
        {
            _list = new List<Link>()
            {
                new Link(){Id=1,Title="Codeclimber",Url="http://codeclimber.net.nz"},
                new Link(){Id=2,Title="Triathlon Geek",Url="http://triathlongeek.eu/"},
                new Link(){Id=3,Title="Wrox",Url="http://www.wrox.com/WileyCDA/"},
                new Link(){Id=4,Title="Front-end Development with ASP.NET Core, Angular, and Bootstrap",Url="http://www.wrox.com/WileyCDA/WroxTitle/Front-end-Development-with-ASP-NET-Core-Angular-and-Bootstrap.productCd-1119181313.html"},
                new Link(){Id=5,Title="Introduction to ASP.NET Core",Url="https://docs.microsoft.com/en-us/aspnet/core/"},
                new Link(){Id=6,Title="Visual Studio Code",Url="https://code.visualstudio.com/"},
                new Link(){Id=7,Title="Visual Studio for Mac",Url="https://www.visualstudio.com/vs/visual-studio-mac/"},
                new Link(){Id=9,Title="Angular",Url="https://angular.io/"},
                new Link(){Id=10,Title="Bootstrap",Url="http://getbootstrap.com/"},
                new Link(){Id=11,Title="Gulp.js",Url="http://gulpjs.com/"},
                new Link(){Id=12,Title="Grunt",Url="https://gruntjs.com/"},
                new Link(){Id=13,Title="Git",Url="https://git-scm.com/"},
                new Link(){Id=14,Title="Docker",Url="https://www.docker.com/"}
            };

        }

        public IQueryable<Link> GetLinks()
        {
            return _list.AsQueryable();
        }
    }
}
